/*******************************************************
Filename		:  di_activity_intent.sql
Release 		:  c2.0
SIR			:  1509
Description		:  Creates the dimension table DI_ACTIVITY_INTENT and related objects.
Author			:  Thieu Nguyen
Date			:  7/15/2003
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/

spool di_activity_intent.log

drop sequence seq_activity_intent;

create sequence seq_activity_intent
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_activity_intent;
create table di_activity_intent
(PK_ISN number(12) not null,
 ACTIVITY_INTENT varchar2(20) not null)
tablespace storetdata
storage (initial 256K next 256K)
nologging;

alter table di_activity_intent
add constraint pk_activity_intent primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128K next 128K);

--add data to di_activity_intent
set serveroutput on

declare
cursor c1 is select distinct activity_intent from fa_biological_result
where activity_intent is not null;
begin
for c1_var in c1 loop
insert into di_activity_intent(PK_ISN,ACTIVITY_INTENT)
values(seq_ACTIVITY_INTENT.nextval,c1_var.ACTIVITY_INTENT);
end loop;
commit;
end;
/

--update fks in FA_BIOLOGICAL_RESULT
declare
cursor c1 is select * from di_activity_intent;

begin
for c1_var in c1 loop
update FA_BIOLOGICAL_RESULT
set FK_ACT_INTENT = c1_var.pk_isn
where ACTIVITY_INTENT = c1_var.ACTIVITY_INTENT;
end loop;
commit;
end;
/
spool off;
